import itertools as it
from time import time
import sys
from config import chars, ords, RTList, RFList, RTqstart, RTDict
from tree_creator_base_final import RFHelper, InitialiseRTList

'''
Copyright Dr Paul Brown and Prof. Trevor Fenner 2020.
'''

def RFHelper_adjlist(n, q, L):
    # generate 2-tuples comprising the canonical weight sequence of the tree
	# with the root removed together with the adjacency list of the rooted
	# tree; this routine is only used in UFT (i.e., at the top level)

    if q == 2:
        for t in range((n - 1) // 2, -1, -1):
            adjlist = []
            for i in range(2, 2 * t + 1, 2):
                # weight 2 vertices
                adjlist +=[0, i], [i - 1]
            # leaves
            adjlist += [[0]] * (n - 1 - 2 * t)
            # adjacency list of the root
            root_adj = [i for i in range(1, 2 * t + 1, 2)] + \
                           [i for i in range(2 * t + 1, n)]
            yield '21' * t + '1' * (n - 1 - 2 * t), [root_adj] + adjlist

    elif q == (n - 1) // 2:

        # construct the adjacency list representation of the subtrees of
        # order n - q using the cache RTDict
		# then increment each vertex number (except vertex 0) by q
        # note that, for each subtree, the first adjacency list corresponds
		# to the root of the whole tree, but missing the edge to vertex 1
        ls_adjs = [[[nb + q if nb != 0 else nb for nb in vx_adj]
						for vx_adj in RTDict[t]] for t in RTList[n - q]]
        start = 0
        if n % 2 == 0: start = len(RTList[n // 2])
        for a in RTList[q]:
            # add 1 to the indices in the adjacency lists of the
            # first subtree of the root
            a_adj = [[nb + 1 for nb in vx_adj] for vx_adj in RTDict[a]]
            # make the root of the first subtree adjacent
            # to the root of the whole tree
            a_adj[0].append(0)
            # enumerate RFList[n - q][start:] to synchronise with ls_adjs
            for i, b_hash in enumerate(RFList[n - q][start:], start):
                b_adj = ls_adjs[i]
                # [1] + b_adj[0] is the adjacency list of the root
				# a_adj is the adjacency lists of the first subtree
                # b_adj[1:] is the adjacency lists of the rest of the tree
                yield a + b_hash, [[1] + b_adj[0]] + a_adj + b_adj[1:]
            start +=1

    elif q >= n - L:
        ls_adjs = [[[nb + q if nb != 0 else nb for nb in vx_adj]
                            for vx_adj in RTDict[t]] for t in RTList[n - q]]
        for a in RTList[q]:
            a_adj = [[nb + 1 for nb in vx_adj] for vx_adj in RTDict[a]]
            a_adj[0].append(0)
            start = RTqstart[n - q][q]
            a_sentinel = a + 'z'
            for newstart, bhash in enumerate(RFList[n - q][start:], start):
                if a_sentinel >= bhash: break
            for i, b_hash in enumerate(RFList[n - q][newstart:], newstart):
                b_adj = ls_adjs[i]
                yield a + b_hash, [[1] + b_adj[0]] + a_adj + b_adj[1:]
	
	# recursive case
    else:
        RFGenArr = [None for _ in range(q + 1)]
        # allocate array for generators of adjacency lists
        adjgens = [None for _ in range(q + 1)]
        for r in range(2, q + 1):
            RFGenArr[r] = RFHelper(n - q, r, L)
            RFGenArr[r], RFGA = it.tee(RFGenArr[r], 2)
            adjgens[r] = (Adjsplit(f, q + 1) for f in RFGA)

        for a in RTList[q]:
            a_sentinel = a + 'z'
            a_adj = [[nb + 1 for nb in vx_adj] for vx_adj in RTDict[a]]
            a_adj[0].append(0)
            for r in range(q, 1, - 1):
                RFGenArr[r], RFHelperListGen = it.tee(RFGenArr[r], 2)
                # make a copy of the adjacency lists generator
                adjgens[r], gen_adjs = it.tee(adjgens[r], 2)
                if r == q:
                    cen_adj, bhash_adj = next(gen_adjs)
                    for b_hash in RFHelperListGen:
                        if a_sentinel >= b_hash: break
                        cen_adj, bhash_adj = next(gen_adjs)
                    yield a + b_hash, cen_adj + a_adj + bhash_adj
                for b_hash in RFHelperListGen:
                    cen_adj, bhash_adj = next(gen_adjs)
                    yield a + b_hash, cen_adj + a_adj + bhash_adj

def AdjListFromWS(tree):
    # returns the adjacency lists from the weight sequence of the tree

    n = len(tree)
    A = [[] for _ in range(n)]
    ws = [ords[t] for t in tree]
    for i in range(n):
        j = i + 1
        # loop through weight sequence for this subtree
        # add in adjacencies for vertex i
        while j < i + ws[i]:
            A[i].append(j)
            A[j].append(i)
            j += ws[j]         # get next neighbour of i
    # add the edge joining the two centroids where applicable
    if ws[0] == n / 2:
        A[0].append(n // 2)
        A[n // 2].append(0)
    return A

def Adjsplit(ws, stpt):
    # returns a 2-tuple comprising the adjacency list of the root together
    # with the adjacency lists corresponding to bhash using the cache RTDict

    # ws is the weight sequence bhash, and stpt is the start index of
    # bhash in the weight sequence of the whole tree
	forest_adj = []
	root_adj = []
	i = 0
	# i iterates through the indices of the children of the root
	while i < len(ws):
		k = ords[ws[i]]
		# get the adjacency lists of the subtrees of the root from the cache
		# RTDict, and increment the vertex indices of the current subtree
		adj = [[stpt + i + nb for nb in vx_adj]
                    for vx_adj in RTDict[ws[i: i + k]]]
		# add back-edge to the root
		adj[0].append(0)
		forest_adj +=adj
		# append edge from the root
		root_adj.append(stpt + i)
		# move to the next child of the root
		i += k
	return [[1] + root_adj], forest_adj

def InitialiseRTDict(L):
    # compute adjacency lists for rooted trees up to order L

    # initialise dictionary cache of adjacency lists for small trees
    RTDict['1'] = [[]]
    RTDict['21'] = [[1], [0]]
    RTDict['321'] = [[1], [0, 2], [1]]
    RTDict['311'] = [[1, 2], [0], [0]]
    RTDict['4321'] = [[1], [0, 2], [1, 3], [2]]
    RTDict['4311'] = [[1], [0, 2, 3], [1], [1]]
    RTDict['4211'] = [[1, 3], [0, 2], [1], [0]]
    RTDict['4111'] = [[1, 2, 3], [0], [0], [0]]

    # compute adjacency lists for rooted trees of order > 4
    for k in range(5, L + 1):
        for rt in RTList[k]:
            RTDict[rt] = AdjListFromWS(rt)

def UFT(n, L):
    # generate 2-tuples comprising the canonical weight sequence of
    # the unicentroidal tree together with its adjacency lists

    rootchar = chars[n]
    for q in range((n - 1) // 2, 1, -1):
        for a, a_adj in RFHelper_adjlist(n, q, L): yield rootchar + a, a_adj

def BFT(n):
    # generate 2-tuples comprising the canonical weight sequence of
    # the bicentroidal trees together with its adjacency lists

    # make a duplicate dictionary of the adjacency lists for the subtree rooted
	# at the second centroid, incrementing the vertex indices by n / 2
    RTDict_2 = {}
    for rt in RTList[n // 2]:
        RTDict_2[rt] = [[nb + n // 2 for nb in vx_adj] for vx_adj in RTDict[rt]]
        # add in the edge joining the second centroid to the first
        RTDict_2[rt][0].append(0)

    for start, a_1 in enumerate(RTList[n // 2]):
        adj_1 = [t for t in RTDict[a_1]]
        # add in the edge joining the first centroid to the second
        adj_1[0].append(n // 2)
        for a_2 in RTList[n // 2][start:]:
            # get the adjacency lists of the subtree rooted at the second centroid
            adj_2 = [t for t in RTDict_2[a_2]]
            yield a_1 + a_2, adj_1 + adj_2

def FreeTrees(n, L):
    # generate 2-tuples comprising the canonical weight sequence of
    # the free tree together with its adjacency lists for all n

    if n == 1: yield '1', [[]]
    elif n == 2: yield '11', [[1], [0]]
    elif n == 3: yield '311', [[1, 2], [0], [0]]
    elif n == 4:
        yield '4111', [[1, 2, 3], [0], [0], [0]]
        yield '2121', [[1, 2], [0], [0, 3], [2]]
    else:
        for a, a_adj in UFT(n, L): yield a, a_adj
		# add bicentroidal trees when n is even
        if n % 2 == 0:
            for a, a_adj in BFT(n): yield a, a_adj

def main(N):

    sttime = time()
    count = 0
    L = (N // 2) + 1
    # Initialise Cache for order <= L
    InitialiseRTList(L)
    InitialiseRTDict(L)
    # Get all free trees
    for g in FreeTrees(N, L):
        # print(g)
        count += 1
    print('BRFE(adjlist)', N, count, time() - sttime)

if __name__ == '__main__':
    # to check orders up to 27
    for i in range(28):
       main(i)
    # to run from command line use:
    # main(int(sys.argv[1]))



